//  This script file is copyright 1999 Henter-Joyce, Inc.
//
//  All Rights Reserved
//
//  Henter-Joyce software is distributed and licensed "as is", all
//  warranties, either express or implied, are disclaimed as to the
//  software and its quality, performance, or fitness for any
//  particular purpose.  You, the consumer, bear the entire risk
//  relating to the quality of the software and if the software
//  proves to have any defects, you assume the cost of any necessary
//  servicing or repairs.

//  Description: Installation script for JAWS for Windows

// Install Scripts for JFW 3.31
// Original Author: J. David Boyd
// Maintained by Mike Pedersen and Ralph (Ernie) Ocampo
// Last Modified: 08/3/99 reo

@DefineProto
	//Ask a Yes/No question, returns Yes/No (True/False)
	//Uses Options 150-151
	@Integer @GetYesNo ( @In @QString @Question )

	//Compare Strings, If Same, return @Yes
	@Integer @IsEqual (@In @QString @String1, @In @QString @String2)

	//Compare Strings, If Greater, return @Yes
	@Integer @IsGreater (@In @QString @String1, @In @QString @String2)

	//Displays Options picked for this install
	@Void @ShowMyOptions ( @Void )

	//Displays and verify's options for this install
	@Integer @VerifyOptions ( @Void )

	@VOID @PlayWav( @IN @QSTR @WavFile,@IN @INT @Wait)  //Play WAV file, swiped from tutorial

	@Void @ModifyJFWINI( @Void )  //Make Modifications to JFW.INI

	//Get Installation Type (Check for default.ini)
	//Uses Options 100-104
	@Void @GetInstallType ( @Out @QString @MyInstall )

	//Check version numbers for files created by Microsoft Active Accessibility (MSAA)
	@Void @CheckMSAA ( @Void )

	//Check Version Number of file
	@Integer @CheckFile ( @In @QString @Filename, @In @QString @Version )

	//Reset Synth/Braille Devices when user choosed to redo options
	@Void @ResetDevices ( @Void )

    @Integer @CheckForEverlock( @Void )

    // check to see if the everlock files exist anywhere in the system
    @Integer @CheckForAuthorization( @Void )

    // see if we are running under NT
    @Integer @IsSystemNT( @Void)

    @Integer @CopyHJCR( @Void )

    @Void @FindHighestInstalledSynth( @Void )

    @Integer @Already( @In @QString @DeviceType, @In @Qstring @Synth )

    @Integer @AlreadyThenReplace( @In @QString @DeviceType, @In @Qstring @Synth )

    @Void @AddAutoAssigns( @Void )


    @Integer @FindEloqInInx( @In @QString @InxPath )


    @Integer @InvalidDirectoryName( @In @Qstring @JFWDir )

@EndProto

@DefineFunc @Void @GetInstallType ( @Out @QString @MyInstall )

// @Display
// @Cls
// Thank you for participating In the JFW 3.31 beta program.  Please press
// enter to continue.
// @Pause
// @EndDisplay

  //If there is a default.ini in the install directory
  // then run a forced install and get the install options
  // from default.ini, otherwise ask user for installation
  // type (Full, Typical, Custom)
//Clear Options 100-105
  @ClearOption (100)
  @ClearOption (101)
  @ClearOption (102)
  @ClearOption (103)
  @ClearOption (104)
  @ClearOption (105)
  @If (@Exists("@StartupDrive:\\@StartupDir\\makedef.ini"))
    @SetOption(105)
    @InstallType = "MAKEDEF"
  @Else

  @ClearOption (500)
  @ClearOption (501)

  @If (@Exists("@StartupDrive:\\@StartupDir\\default.ini")
    // ***************
      @DlgCtrlSize(0, 10,3,13,35)
      @GetOption
      @Cls
      The Automatic Install will install JAWS for Windows
      and the Eloquence software synthesizer set to
      American English. No braille options will be selected,
      and the merge program will not be run.
      If you have additional synthesizers or braille displays,
      or desire other options, choose the Custom Install.
      Use the arrow keys to select an item, and then press ENTER.
      Installation type:
      @Option 500 = "Automatic Install"
      @Option 501 = "Custom Install"
      @EndOption
      @DlgCtrlSize(0, -1,-1,0,0)
      @If (@OptionIsSet(500))
        // ***************
        @SetOption(104)
        @InstallType = "FORCED"
        @MyInstall = "FORCED"
        @SetOption(3001)
        // @Keyboard  = "DESKTOP"
        @Return()
      @Endif
   @Endif


/*
  @DlgCtrlSize(0, 3,3,7,35)
  @GetOption
  @Cls
  Which type of installation would you like to do today?
  @Option 100 = "Standard Desktop Configuration"
  @Option 101 = "Standard Laptop Configuration"
  @Option 102 = "Custom Installation"
//    @Option 103 = "Partial Installation"  //Partial is for re-installs (later use)
//    @Option 104 = "Forced"  //Forced = only if exists default.ini
//    @Option 105 = "Make Defaults" //MakeDef = only if exists makedef.ini
  @EndOption
  @DlgCtrlSize(0, -1,-1,0,0)
  @EndIf
//Set @InstallType
  @If (@OptionIsSet(100))
	@MyInstall = "Standard DESKTOP"
  @ElseIf (@OptionIsSet(101))
	@MyInstall = "Standard LAPTOP"
  @ElseIf (@OptionIsSet(102))
	@MyInstall = "CUSTOM"
  @ElseIf (@OptionIsSet(103))
	@MyInstall = "PARTIAL"
  @ElseIf (@OptionIsSet(104))
	@MyInstall = "FORCED"
  @ElseIf (@OptionIsSet(105))
	@MyInstall = "MAKEDEF"
  @Else
	@MyInstall = "ERROR"
  @Endif

*/


// @ClearOption (100)
// @ClearOption (101)
// @ClearOption (102)
// @ClearOption (103)
// @ClearOption (104)
// @ClearOption (105)

    @SetOption(102)
    @MyInstall = "CUSTOM"

  @return()
@EndFunc

@DefineFunc @Void @PlayWav(@In @QString @WavFile,@In @Integer @Wait)
@If (@SoundOn == @TRUE)
    @If (@Exists(@WavFile))
      @If(@MCISendString("open waveaudio!@WavFile alias wavfile") == 0)
            @MCISendString("break wavfile on 27") // quit if they hit the "ESC" key

            @If(@Wait)
                @MCISendString("play wavfile wait")
            @Else
                @MCISendString("play wavfile")
            @Return()
            @EndIf
      @MCISendString("close all")
      @Else
            @Display
            When attempting to play the WAV file: @WAVFile

            The following error was reported by the operating system:

            @MCIErrorMsg

            @Pause
            @EndDisplay
      @EndIf
    @Endif
@Endif
@Return()
@EndFunc

@DefineFunc @Integer @GetYesNo ( @In @QString @Question )
@ClearOption(125)
@ClearOption(126)
@ShowName(1,"@Question")
@GetOption
	@Cls
	@Question
	@Option	126 = "No"
	@Option	125 = "Yes"
@EndOption
@If (@OptionIsSet(125))
  @YesNoValue = @Yes
@Else
  @YesNoValue = @No
@Endif
@ShowName(1,"  ")
@return(@YesNoValue)
@EndFunc

@DefineFunc @Integer @IsEqual (@In @QString @String1, @In @QString @String2)
  @If (@StrCmpNos(@String1,@String2)==0)
    @IsEqualValue = @Yes
  @Else
    @IsEqualValue = @No
  @EndIf
  @Return(@IsEqualValue)
@EndFunc

@DefineFunc @Integer @IsGreater (@In @QString @String1, @In @QString @String2)
  @If (@StrCmpNos(@String1,@String2)==1)
    @IsGreaterValue = @Yes
  @Else
    @IsGreaterValue = @No
  @EndIf
  @Return(@IsGreaterValue)
@EndFunc

/* from below
Windows Directory = @WinHomeDrive@!:@WinHomeDir
Install Directory = @InstallDrive@!:@InstallDir
*/

@DefineFunc @Void @ShowMyOptions ( @Void )
@ShowName(1,"Show Installation Options")


@If(@FindEloqInInx("@TTempDir\\synth.inx") == @True )
    @TempSynthFileCounter = @SynthFileCounter
@Else
    @If(@SoundCardInstalled)
        @TempSynthFileCounter = (@SynthFileCounter + 1)
    @Else
        @TempSynthFileCounter = (@SynthFileCounter)
    @Endif
@Endif

@Display

@Cls
You picked the following options:

JFW Directory = @JFWDrive@!:@JFWDir

@If (@TempSynthFileCounter == 1) You are installing @TempSynthFileCounter synthesizer. @Else You are installing @TempSynthFileCounter synthesizers. @Endif
@If (@BrailleFileCounter == 1) You are installing @BrailleFileCounter braille display. @Else You are installing @BrailleFileCounter braille displays. @Endif

@Pause
@EndDisplay

@ShowName(1,"                    ")
@return()
@EndFunc

@DefineFunc @Integer @VerifyOptions ( @Void )

@If(@FindEloqInInx("@TTempDir\\synth.inx") == @True )
    @TempSynthFileCounter = @SynthFileCounter
@Else
    @If(@SoundCardInstalled)
        @TempSynthFileCounter = (@SynthFileCounter + 1)
    @Else
        @TempSynthFileCounter = (@SynthFileCounter)
    @Endif
@Endif

@ClearOption(152)
@ClearOption(153)
@ShowName(1,"Verify Installation Options")
@DlgCtrlSize(0, 12, 0, 15, 30)
@GetOption
@Cls
You picked the following options:

JFW Directory = @JFWDrive@!:@JFWDir

@If (@TempSynthFileCounter == 1) You are installing @TempSynthFileCounter synthesizer. @Else You are installing @TempSynthFileCounter synthesizers. @Endif
@If (@BrailleFileCounter == 1) You are installing @BrailleFileCounter braille display. @Else You are installing @BrailleFileCounter braille displays. @Endif

Are these options correct?
@Option 152 = "Yes"
@Option 153 = "No, Let me change them"
@EndOption
@DlgCtrlSize (0,-1,-1,0,0)
@ShowName(1,"                    ")
@return(@OptionIsSet(152))
@EndFunc

@DefineFunc @Void @ModifyJFWINI( @Void )
	//The first 3 settings (Default Files) were pulled from the JFW 2.00.8 script files
	// now take care of the default JCF file
	@SetINI("Default Files", "DefaultJCFFile", "default", "@JFWDrive:\\@JFWDir\\JFW.INI")

	// now take care of the default dictionary file
	@SetINI("Default Files", "DefaultDictionaryFile", "default", "@JFWDrive:\\@JFWDir\\JFW.INI")

	// now take care of the default graphic file
	@SetINI("Default Files", "DefaultGraphicsFile", "default", "@JFWDrive:\\@JFWDir\\JFW.INI")

	//These are the new ModifyJFWINI settings!
	// take care of default macro file
	@SetINI("Options", "KeyboardType", "@KeyboardType", "@JFWDrive:\\@JFWDir\\JFW.INI")

/*
	// now set the Synthesizer settings
	@If (@NumSynths >= 1)
		@SetINI("Synthesizers","Synth1Name","@PrimarySynthShort","@OutDrive:\\@SubDir\\JFW.INI")
		@SetINI("Synthesizers","Synth1LongName","@PrimarySynthFull","@OutDrive:\\@SubDir\\JFW.INI")
		@SetINI("Synthesizers","Synth1Port","@PrimarySynthPort@PrimarySynthPortInfo","@OutDrive:\\@SubDir\\JFW.INI")
		@If (@IsEqual(@PrimarySynthDriver,"UNKNOWN")==@False)	@SetINI("Synthesizers","Synth1Driver","@PrimarySynthDriver","@OutDrive:\\@SubDir\\JFW.INI") @EndIf
		@If (@NumSynths >= 2)
			@SetINI("Synthesizers","Synth2Name","@SecondarySynthShort","@OutDrive:\\@SubDir\\JFW.INI")
			@SetINI("Synthesizers","Synth2LongName","@SecondarySynthFull","@OutDrive:\\@SubDir\\JFW.INI")
			@SetINI("Synthesizers","Synth2Port","@SecondarySynthPort@SecondarySynthPortInfo","@OutDrive:\\@SubDir\\JFW.INI")
			@If (@IsEqual(@SecondarySynthDriver,"UNKNOWN")==@False)	@SetINI("Synthesizers","Synth2Driver","@SecondarySynthDriver","@OutDrive:\\@SubDir\\JFW.INI") @EndIf
      		@If (@NumSynths >= 3)
    			@SetINI("Synthesizers","Synth3Name","@TertiarySynthShort","@OutDrive:\\@SubDir\\JFW.INI")
    			@SetINI("Synthesizers","Synth3LongName","@TertiarySynthFull","@OutDrive:\\@SubDir\\JFW.INI")
    			@SetINI("Synthesizers","Synth3Port","@TertiarySynthPort@TertiarySynthPortInfo","@OutDrive:\\@SubDir\\JFW.INI")
    			@If (@IsEqual(@TertiarySynthDriver,"UNKNOWN")==@False)	@SetINI("Synthesizers","Synth3Driver","@TertiarySynthDriver","@OutDrive:\\@SubDir\\JFW.INI") @EndIf
    		@Endif
		@Endif
	@Else
		//do nothing for no synth drivers
	@Endif


	// now set the Braille Device settings
	@If (@NumBraille >= 1)
		@SetINI("BrailleDisplays","Braille1Name","@PrimaryBrailleShort","@OutDrive:\\@SubDir\\JFW.INI")
		@SetINI("BrailleDisplays","Braille1LongName","@PrimaryBrailleFull","@OutDrive:\\@SubDir\\JFW.INI")
		@SetINI("BrailleDisplays","Braille1Port","@PrimaryBraillePort@PrimaryBraillePortInfo","@OutDrive:\\@SubDir\\JFW.INI")
		@If (@IsEqual(@PrimaryBrailleDriver,"UNKNOWN")==@False)	@SetINI("BrailleDisplays","Braille1Driver","@PrimaryBrailleDriver","@OutDrive:\\@SubDir\\JFW.INI") @EndIf
		@If (@NumBraille >= 2)
			@SetINI("BrailleDisplays","Braille2Name","@SecondaryBrailleShort","@OutDrive:\\@SubDir\\JFW.INI")
			@SetINI("BrailleDisplays","Braille2LongName","@SecondaryBrailleFull","@OutDrive:\\@SubDir\\JFW.INI")
			@SetINI("BrailleDisplays","Braille2Type","@SecondaryBrailleType","@OutDrive:\\@SubDir\\JFW.INI")
			@SetINI("BrailleDisplays","Braille2Port","@SecondaryBraillePort@SecondaryBraillePortInfo","@OutDrive:\\@SubDir\\JFW.INI")
			@SetINI("BrailleDisplays","Braille2Extra","@SecondaryBrailleExtra""@OutDrive:\\@SubDir\\JFW.INI")
			@If (@IsEqual(@SecondaryBrailleDriver,"UNKNOWN")==@False)	@SetINI("BrailleDisplays","Braille2Driver","@SecondaryBrailleDriver","@OutDrive:\\@SubDir\\JFW.INI") @EndIf
		@Endif
	@Else
		// Do nothing for no BrailleDisplays
	@Endif
*/
@return()
@EndFunc

@DefineFunc	@Void @CheckMSAA ( @Void )
@RunMSAA = @False
@If     (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\advpack.dll",  "4.71.0514.0")  == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\comctl32.dll", "4.71.0109.0")  == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\gdi.exe",      "4.01.0970")    == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\gdi32.dll",    "4.01.0970")    == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\oleacc.dll",   "4.01.0970.0")  == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\oleaut32.dll", "2.20.4054")    == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\stdole2.tlb",  "2.20.4054")    == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\user.exe",     "4.01.0970")    == @False)
    @RunMSAA = @True
@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\user32.dll",   "4.01.0970")    == @False)
    @RunMSAA = @True
//@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\w95inf16.dll", "4.71.0016.0")  == @False)
//    @RunMSAA = @True
//@ElseIf (@CheckFile("@WinSystemDrive:\\@WinSystemDir\\w95inf32.dll", "4.71.0016.0")  == @False)
//    @RunMSAA = @True
@Else
  //Don't need to run MSAA
@Endif
@return()
@EndFunc

@DefineFunc	@Integer @CheckFile ( @In @QString @Filename, @In @QString @Version )

// @Display
// @Cls
//  Version of @Filename (@VerInfo("@Filename",0)) Is Equal to @Version     :@IsEqual(@VerInfo("@Filename",0), "@Version")
//  Version of @Filename (@VerInfo("@Filename",0)) Is Greater than @Version :@IsGreater( @VerInfo("@Filename",0), "@Version")
// @Pause
// @EndDisplay

@return(  (@IsEqual( @VerInfo("@Filename",0), "@Version") || @IsGreater( @VerInfo("@Filename",0), "@Version")) )
@EndFunc

@DefineFunc	@Void @ResetDevices( @Void )
@PrimarySynth  	= "UNKNOWN"
@PrimarySynthDriver  	= "UNKNOWN"
@PrimarySynthFull	= "UNKNOWN"
@PrimarySynthShort	= "UNKNOWN"
@PrimarySynthType	= "UNKNOWN"
@PrimarySynthPort	= "UNKNOWN"
@PrimarySynthPortInfo	= "UNKNOWN"
@PrimarySynthExtra	= "UNKNOWN"
@SecondarySynth	= "UNKNOWN"
@SecondarySynthDriver	= "UNKNOWN"
@SecondarySynthFull	= "UNKNOWN"
@SecondarySynthShort	= "UNKNOWN"
@SecondarySynthType	= "UNKNOWN"
@SecondarySynthPort	= "UNKNOWN"
@SecondarySynthPortInfo = "UNKNOWN"
@SecondarySynthExtra	= "UNKNOWN"
@TertiarySynth	= "UNKNOWN"
@TertiarySynthDriver	= "UNKNOWN"
@TertiarySynthFull	= "UNKNOWN"
@TertiarySynthShort	= "UNKNOWN"
@TertiarySynthType	= "UNKNOWN"
@TertiarySynthPort	= "UNKNOWN"
@TertiarySynthPortInfo = "UNKNOWN"
@TertiarySynthExtra	= "UNKNOWN"
@PrimaryBraille	= "UNKNOWN"
@PrimaryBrailleDriver	= "UNKNOWN"
@PrimaryBrailleFull	= "UNKNOWN"
@PrimaryBrailleShort	= "UNKNOWN"
@PrimaryBrailleType	= "UNKNOWN"
@PrimaryBraillePort	= "UNKNOWN"
@PrimaryBraillePortInfo = "UNKNOWN"
@PrimaryBrailleExtra	= "UNKNOWN"
@SecondaryBraille	= "UNKNOWN"
@SecondaryBrailleDriver = "UNKNOWN"
@SecondaryBrailleFull	= "UNKNOWN"
@SecondaryBrailleShort	= "UNKNOWN"
@SecondaryBrailleType	= "UNKNOWN"
@SecondaryBraillePort	= "UNKNOWN"
@SecondaryBraillePortInfo = "UNKNOWN"
@SecondaryBrailleExtra	= "UNKNOWN"

@SynthFileCounter = 0
@BrailleFileCounter = 0
@NumSynths = 0
@NumBraille = 0


@ClearOption(2000)
@ClearOption(2001)
@ClearOption(2002)
@ClearOption(2003)
@ClearOption(2004)
@ClearOption(2005)
@ClearOption(2006)
@ClearOption(2007)


@ClearOption(3001)
@ClearOption(3002)
@ClearOption(3003)
@ClearOption(3004)
@ClearOption(3005)
@ClearOption(3006)
@ClearOption(3007)







@return()
@EndFunc




@DefineFunc @Integer @CheckForEverlock( @Void )

    @EverlockPath = @FileSearch("JFW_0302.SYS","",,8,21,4)

    @If ( @StrFind("@EverlockPath", "JFW_0302.SYS") == -1 )
        @If( @Exists("C:\\JFW_0302.SYS") )
            @Return(@True)
        @Else
            @Return(@False)
        @Endif
    @Else
        @Return(@True)
    @Endif

    @Return(@False)
@EndFunc





@DefineFunc @Integer @CheckForAuthorization( @Void )

    @AuthorizationPath = @FileSearch("JFW.CPS","",,8,21,4)

    @If ( @StrFind("@AuthorizationPath", "JFW.CPS") == -1 )
        @If( @Exists("C:\\JFW.CPS\\JFW.CPS") )
            @SQCPS = @True
            @Return(@True)
        @Else
            @If (@WinNT)
            @Else
                @AuthorizationPath = @FileSearch("JFW_0302.SYS","",,8,21,4)

                @If ( @StrFind("@AuthorizationPath", "JFW_0302.SYS") == -1 )
                    @If( @Exists("C:\\JFW_0302.SYS") )
                        @Return(@True)
                    @Else
                        @Return(@False)
                    @Endif
                @Else
                    @Return(@True)
                @Endif
            @Endif
        @Endif
    @Else
        @Return(@True)
    @Endif

    @Return(@False)
@EndFunc



@DefineFunc @Integer @IsSystemNT( @Void)

    @If ( @StrFind("@WinSystemDir", "SYSTEM32") == -1 )
        @Return(@False)
    @Else
        @Return(@True)
    @Endif

    @Return(@False)

@EndFunc


@DefineFunc @Integer @CopyHJCR( @Void )

  @If (@Exists("C:\\JFW.CPS\\JFW.CPS"))
    @Return(@True)
  @Else

    @If (@Exists("@JFWDrive:\\@JFWDir\\HJCR.EXE"))
    @Else
      @HJCRPath = @FileSearch("HJCR.EXE","\\",,8,21,2)

      @If ( @StrFind("@HJCRPath", "HJCR.EXE") == -1 )
          @Return(@False)
      @Else
          @If( @FileSize("@HJCRPath") > 20000 )
            @Copy( "@HJCRPath", "@OutDrive:\\@SubDir\\*.*")
          @Endif
          @Return(@True)
      @Endif
    @Endif
    @Return(@True)

  @Endif
  @Display
  @Cls
  You should never see this message.  COMMPROC.INC, in CopyHJCR
  @Pause
  @EndDisplay
  @Return(@False)  // should never get here!
@EndFunc

@DefineFunc	@Void @FindHighestInstalledSynth( @Void )
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth1Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 2
	@Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth2Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 3
    @Endif
    @If ( @StrCmpNos( @GetINI("Synthesizers", "Synth3Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 4
    @Endif
    @If ( @StrCmpNos( @GetINI("Synthesizers", "Synth4Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 5
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth5Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 6
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth6Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 7
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth7Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 8
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth8Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 9
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth9Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 10
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth10Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 11
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth11Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 12
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth12Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 13
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth13Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 14
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth14Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 15
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth15Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 16
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth16Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 17
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth17Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 18
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth18Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 19
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth19Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 20
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth20Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 21
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth21Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 22
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth22Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 23
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth23Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 24
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth24Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 25
    @Endif
	@If ( @StrCmpNos( @GetINI("Synthesizers", "Synth25Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), "") != 0)
    	@HighestInstalledSynth = 26
    @Endif





	@Return ()
@EndFunc



@DefineFunc	@Integer @Already( @In @QString @DeviceType, @In @Qstring @Synth )

    @If ( @Strcmpnos( "@DeviceType", "Synthesizers") == 0)

    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth1Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth2Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth3Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth4Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth5Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth6Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth7Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth8Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth9Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth10Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth11Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth12Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth13Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth14Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth15Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth16Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth17Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth18Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth19Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth20Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth21Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth22Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth23Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth24Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth25Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif

    @EndIf


    @If ( @Strcmpnos( "@DeviceType", "BrailleDisplays") == 0)

    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille1Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille2Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille3Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille4Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille5Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille6Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille7Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille8Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille9Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille10Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille11Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille12Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille13Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille14Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille15Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille16Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille17Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille18Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille19Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille20Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille21Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille22Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille23Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille24Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille25Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (@True)
    	@Endif

    @Endif

	@Return (@False)
@EndFunc





@DefineFunc	@Integer @AlreadyThenReplace( @In @QString @DeviceType, @In @Qstring @Synth )

    @If ( @Strcmpnos( "@DeviceType", "Synthesizers") == 0)

    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth1Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (1)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth2Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (2)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth3Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (3)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth4Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (4)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth5Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (5)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth6Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (6)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth7Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (7)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth8Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (8)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth9Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (9)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth10Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (10)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth11Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (11)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth12Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (12)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth13Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (13)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth14Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (14)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth15Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (15)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth16Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (16)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth17Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (17)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth18Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (18)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth19Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (19)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth20Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (20)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth21Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (21)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth22Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (22)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth23Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (23)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth24Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (24)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("@DeviceType", "Synth25Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (25)
    	@Endif

    @EndIf


    @If ( @Strcmpnos( "@DeviceType", "BrailleDisplays") == 0)

    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille1Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (1)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille2Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (2)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille3Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (3)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille4Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (4)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille5Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (5)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille6Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (6)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille7Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (7)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille8Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (8)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille9Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (9)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille10Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (10)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille11Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (11)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille12Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (12)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille13Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (13)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille14Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (14)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille15Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (15)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille16Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (16)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille17Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (17)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille18Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (18)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille19Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (19)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille20Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (20)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille21Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (21)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille22Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (22)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille23Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (23)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille24Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (24)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("BrailleDisplays", "Braille25Name",  "@OutDrive:\\@JFWDir\\JFW.INI"), @Synth) == 0)
        	@Return (25)
    	@Endif

    @Endif

	@Return (@False)
@EndFunc













@DefineFunc @Void @AddAutoAssigns( @Void )

	@SetINI("386enh","Com1AutoAssign","0","@WinDrive:\\@WinDir\\SYSTEM.INI")
	@SetINI("386enh","Com2AutoAssign","0","@WinDrive:\\@WinDir\\SYSTEM.INI")
    @Return()
@EndFunc




@DefineFunc	@Integer @FindEloqInInx( @In @QString @InxPath )

    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName1",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName2",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName3",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName4",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName5",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName6",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName7",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName8",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName9",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName10",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName11",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName12",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName13",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName14",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName15",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName16",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName17",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName18",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName19",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName20",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName21",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName22",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName23",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName24",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif
    	@If ( @StrCmpNos( @GetINI("Synth", "ItemName25",  "@InxPath"), "eloq") == 0)
        	@Return (@True)
    	@Endif

    	@Return (@False)
@EndFunc

@DefineFunc @Integer @InvalidDirectoryName( @In @Qstring @JFWDir )

        @If ( @StrFind( " ", "@JFWDir" ) == -1 )
        @Else
            @Return (@True)
        @Endif

        @If ( @StrFind( ".", "@JFWDir" ) == -1 )
        @Else
            @Return (@True)
        @Endif

        @Return (@False)

@EndFunc
